LOOT_ROW_HEIGHT = 38;
NO_LOOT = "No Loot";
LOOTED = "Looted ";

function LootScrollFrame_OnLoad()
	ScrollFrame_OnLoad();
	LootFrameUpButton:Hide();
	LootFramePrev:Hide();
	LootFrameDownButton:Hide();
	LootFrameNext:Hide();
	this:RegisterEvent("LOOT_SLOT_CLEARED");
	this:RegisterEvent("LOOT_OPENED");
	this:RegisterEvent("LOOT_CLOSED");
	for i=1, LOOTFRAME_NUMBUTTONS do
		local button=getglobal("LootButton"..i);
		button:SetScript("OnEnter", LootScrollFrame_OnEnter);
	end
end

function LootScrollFrame_OnEvent()
	if ( event=="LOOT_CLOSED" ) then
		if ( GetAutoLootDefault() and not LootScrollFrame.loot ) then
			UIErrorsFrame:AddMessage(NO_LOOT, 1.0, 1.0, 0.0, 1.0);
		end		
		LootScrollFrame.loot = nil;
	end
	if ( event=="LOOT_OPENED" ) then
		local message;
		local numloot = GetNumLootItems();
		if ( GetAutoLootDefault() ) then
			this:UnregisterEvent("LOOT_SLOT_CLEARED");
			message = LOOTED..numloot;
			UIErrorsFrame:AddMessage(message, 1.0, 1.0, 0.0, 1.0);
			LootScrollFrame.loot = true;
			for i=1, numloot do
				LootSlot(i);
			end
			CloseLoot();
			this:RegisterEvent("LOOT_SLOT_CLEARED");
		end
	end
	if ( event=="LOOT_SLOT_CLEARED" ) then
		LootFrame_Update();
	end
end

function LootFrame_Update()
	local lootTable=SortLoot();
	local numLootItems=getn(lootTable);
	if ( numLootItems == 0 ) then
		LootFrame:Hide();
	end
	if ( numLootItems <= LOOTFRAME_NUMBUTTONS ) then
		LootScrollFrame:Hide();
	else
		LootScrollFrame:Show();
	end

	local offset = FauxScrollFrame_GetOffset(LootScrollFrame);
	local texture, item, quantity, quality;
	local button, countString, color;
	for index = 1, LOOTFRAME_NUMBUTTONS do
		button = getglobal("LootButton"..index);
		local id = offset + index;
		if ( id <= numLootItems ) then
			local slot=lootTable[id];
			texture, item, quantity, quality = GetLootSlotInfo(slot);
			color = ITEM_QUALITY_COLORS[quality];
			getglobal("LootButton"..index.."IconTexture"):SetTexture(texture);
			getglobal("LootButton"..index.."Text"):SetText(item);
			getglobal("LootButton"..index.."Text"):SetVertexColor(color.r, color.g, color.b);
			countString = getglobal("LootButton"..index.."Count");
			if ( quantity > 1 ) then
				countString:SetText(quantity);
				countString:Show();
			else
				countString:SetText('');
				countString:Hide();
			end
			--button:SetSlot(slot);
			button.slot = slot;
			button.quality = quality;
			button:Show();
		else
			button:Hide();
		end
	end

	-- Scroll frame stuff
	FauxScrollFrame_Update( LootScrollFrame, numLootItems, LOOTFRAME_NUMBUTTONS, LOOT_ROW_HEIGHT );
end

function SortLoot()
	local lootTable={};
	for slot=1, GetNumLootItems() do
		if ( LootSlotIsItem(slot) or LootSlotIsCoin(slot)) then
			tinsert(lootTable, slot);
		end
	end
	return lootTable;
end

function LootScrollFrame_OnEnter()
	GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	GameTooltip:SetLootItem(this.slot);
	CursorUpdate();
end